
kEZDialogViewDispatchEvent       = "ezDialogView_Dispatch_Event"
kEZDialogViewQueryHostHandlerCommand   = "ezDialogView_Query_Host_Handler_Command"
kEZDialogViewDialogArea                = "ezDialogView_Dialog_Area"
kEZDialogViewLoadFromBuffer            = "buffer";
kEZDialogViewLoadFromFile              = "file";
kEZDialogViewXSLT					   = "ezDialogView.xsl";

//------------------------------------------------------------------------------
kTroubleShootingGuide                  = "http://support.turbotax.com/turbotax/ecs/knowledgebase/kb.html?document_id=0050002714"

//-----------------------------------------------------------------------------
var currentFocusItem = "";


//-----------------------------------------------------------------------------
function ezdv_Setup( )
{
   var s="";
   
   // Initialize QueryHost 
    s='<div style="position:absolute;left:-200px;top:0px;width:200px;visibility:hidden">';  
    s += '<input id="'+kEZDialogViewQueryHostHandlerCommand+'" type="text">';
    s += '</div>';
    document.body.insertAdjacentHTML( "beforeBegin", s );
    
   // Initialize DblClick
    s='<div style="position:absolute;left:-200px;top:0px;width:200px;visibility:hidden">';  
    s += '<input id="'+kEZDialogViewDispatchEvent+'" type="text">';
    s += '</div>';
    document.body.insertAdjacentHTML( "beforeBegin", s );

   // disable accelarators  
    document.onkeydown = _ezdv_disableAccelerators;
    document.ondragstart = _ezdv_disableDrag; // disable drag drop
    // take the body out of the tab order
    if( document.body) document.body.tabIndex = -1;
    // make linkes blue
    document.vlinkColor = "#0000ff";
}

//-----------------------------------------------------------------------------
function ezdv_QueryLocal( cmd )
{
   // parse out a local bound value reference from command, and return it if found
   try
   {
      var sp = cmd.split(/(\(\))/); // pull out name from function
      var func = sp[0]; // function name
      var bind = sp[1]; // parameter list of bound value
      if (bind)
      {
         var name = func+"%=%";  // hunt down the "name" part of bound value
         if (bind.match(name))
         {  // if found, extract the "value" part of the bound value
            var valueList = bind.split(name);      // by the time this is called, 
            var value = valueList[1].split(/%:%/); // ezdv_getElementValue() will
            return value[0];                       // have already been evaluated
         }
      }
   } catch (e) {};
   return "";
}

//-----------------------------------------------------------------------------
function ezdv_QueryHost( cmd, params, xslt )
{
   try
   {
       var e = document.getElementById( kEZDialogViewQueryHostHandlerCommand );
       if ( e )
       {
           e.title = (cmd) ? cmd : "";
           if (params) e.title += params;
           var str = ezdv_QueryLocal(e.title);
           if (str) return str; // we have a local value, use it
           e.fireEvent("onclick"); // otherwise, query the host for the value
           var str = e.title;

           if (xslt)
           {
              str = ezdv_XSLT(kEZDialogViewLoadFromBuffer,str,xslt);
              str = ezdv_EvalJS(str);
           }
           if (str.match(/<xmlDIALOG/))
           {
              str = ezdv_XSLT(kEZDialogViewLoadFromBuffer,str);
              str = ezdv_EvalJS(str);
           }
           return str;
       }    
    }
    catch (e) {}
    return "";
}

//-----------------------------------------------------------------------------
function ezdv_DispatchBtnClick( cmd )
{
    var e = document.getElementById( kEZDialogViewDispatchEvent );
    if ( e )
    {
        e.title = (cmd) ? cmd : "";
        e.fireEvent("onclick");
        //alert(e.title);
        return e.title;
    }   
    return "";
}

//-----------------------------------------------------------------------------
function ezdv_loadDialogFromString( buffer )
{
   ezdv_showDialog(kEZDialogViewLoadFromBuffer,buffer);
}

//-----------------------------------------------------------------------------
function ezdv_loadDialogFromFile( fileName )
{
   ezdv_showDialog(kEZDialogViewLoadFromFile,fileName);
}

focusTimer = null;

//-----------------------------------------------------------------------------
function ezdv_XSLT( loadFrom, loadString, xsltTemplate )
{
   var str = ""
   try {
      str += "<br>Loading: Msxml2.DOMDocument.3.0";
      var xmlDoc = new ActiveXObject("Msxml2.DOMDocument.3.0");

      xmlDoc.async = false;
      xmlDoc.resolveExternals = false;
      xmlDoc.validateOnParse = false;

      str += "<br>Loading: " + loadString;
      if (kEZDialogViewLoadFromFile==loadFrom)
      {
         var  idpair = loadString.split(":");
         var fname = idpair[0];
         var id = idpair[1];
        
         xmlDoc.load(fname)
         if(xmlDoc.parseError.errorCode !=0)
         {
            str += "<br><br><font color='red'>Error in "+fname+"+<br>Reason: " +xmlDoc.parseError.reason + "<br>line:" + xmlDoc.parseError.line + "<br>srcText:" + xmlDoc.parseError.srcText + "</font>";
            throw str;
         }
      }
      else if (kEZDialogViewLoadFromBuffer==loadFrom)
      {
         xmlDoc.loadXML(loadString);
      }        
      
      var node;
      str += "<br>Extracting Dialog: " + loadString;
      if (id) str += "[" + id + "]";
      if (id) node = xmlDoc.selectSingleNode('/xmlDIALOG/DIALOG[@id="'+id+'"]')
      else node = xmlDoc.selectSingleNode('/xmlDIALOG')
      if (!node) node = xmlDoc.selectSingleNode('/')

	   var xsltName;
	   if (xsltTemplate) xsltName = xsltTemplate
	   else
	   {
         var xsltAttribute = xmlDoc.selectSingleNode('/xmlDIALOG/@xslt');
   	   if (xsltAttribute) xsltName = xsltAttribute.text;
	      else xsltName = kEZDialogViewXSLT;
	   }

      str += "<br>Loading: Msxml2.FreeThreadedDOMDocument.3.0";
      var xslt= new ActiveXObject("Msxml2.FreeThreadedDOMDocument.3.0");
      xslt.async = false;

      str += "<br>Loading: " + xsltName;
      xslt.load(xsltName)
      if(xslt.parseError.errorCode !=0)
      {  
         str += "<br><br><font color='red'>Error in STYLESHEET<br>Reason: " +xslt.parseError.reason + "<br>line:" + xslt.parseError.line + "<br>srcText:" + xslt.parseError.srcText + "</font>";
         throw str;
      }

      str += "<br>Loading: Msxml2.XSLTemplate.3.0";
      var xslTemplate = new ActiveXObject("Msxml2.XSLTemplate.3.0");
      xslTemplate.stylesheet = xslt;
      str += "<br>Creating: XSLT Processor";
      var xslProc = xslTemplate.createProcessor();

      xslProc.input = node
      str += "<br>Running: XSLT Transform";
      xslProc.transform();
      str = xslProc.output
      // remove ugly namesspace garbage xslt places in file because it offends me.  
      str=str.replace(/\sxmlns:.*?".*?"/g,"")
      return str;   
   } catch (e) 
   { 
      str += "<br><a target='_blank' href='"+kTroubleShootingGuide+"'>trouble shooting guide</a>";
      ezdv_displayDialog("<b><font color='Red'>DIALOG ERROR</font></b><br><br>"+str); 
   }
}

//-----------------------------------------------------------------------------
function ezdv_EvalJS( str )
{
   // Do the magic regEx to evalute all the script code before placing
   // into the DIV
   return str.replace(/%%%(.*?)%%%/g,function($0,$1) { return eval($1.replace("&amp;&amp;","&&")) } )
}

//-----------------------------------------------------------------------------
function ezdv_showDialog( loadFrom, loadString )
{
   var str = ""
   try {
      currentFocusItem = "";

      // Transpose the XML
      str = ezdv_XSLT(loadFrom, loadString);
      if (!str) return;
      
      // Evaluate any embedded JS
      str = ezdv_EvalJS(str); 
      if (!str) return;
      
      // Display the dialog        
      ezdv_displayDialog(str);
      zedvStartTriggers();
      
      ezdv_DispatchBtnClick("event%=%onload%:%tag%=%DIALOG");
   } catch (e) { ezdv_displayDialog("<b><font color='Red'>DIALOG ERROR</font></b><br><br>"+str); }
}

//-----------------------------------------------------------------------------
function ezdv_setFocusItem(id)
{
   try
   {
      currentFocusItem = id;
      return "";
    } catch (exc) {}
}

function _ezdv_setFocusItem()
{
   try
   {
      clearTimeout(focusTimer);

       if (!currentFocusItem) return;
    
       var e = document.getElementById( currentFocusItem );
       if(e)
       {
           try
           {
               if(e.tagName=="INPUT"&&e.type=="text"&&e.value.length>0)e.select();
               e.focus();
           }
           catch(e){}   
       }    
    } catch (exc) {}
}

function ezdv_SuperButtonMouseDown( buttonContainer )
{
	var currentChild=null;
	var tdChild=null;
	try
	{
		// buttonContainer should be the span
		if (buttonContainer) 
		{
			currentChild = buttonContainer.firstChild; // the table body.
			if (currentChild)
			{
				currentChild = currentChild.firstChild; // the row.
				//alert(currentChild.innerHTML);
				if (currentChild)
					currentChild = currentChild.firstChild;	// the table data
				while (currentChild)
				{
					tdChild=currentChild;
					if (currentChild.clickBkg)
					{
						currentChild.style.backgroundImage = 'url("'+currentChild.clickBkg+'")';
					}
					else
					{
						currentChild = currentChild.firstChild;
						if (currentChild)	// if there is a child, it is in image.
						{
							if (currentChild.clickSrc)
								currentChild.src = currentChild.clickSrc;
						}
					}
					currentChild = tdChild.nextSibling;
				}
			}
		}
	}
	catch(e) {};
}

function ezdv_SuperButtonMouseUp( buttonContainer )
{
	var currentChild=null;
	try
	{
		if (buttonContainer) 
		{
			currentChild = buttonContainer.firstChild; // the table body.
			if (currentChild)
			{
				currentChild = currentChild.firstChild; // the row.
				//alert(currentChild.innerHTML);
				if (currentChild)
					currentChild = currentChild.firstChild;	// the table data
				while (currentChild)
				{
					tdChild=currentChild;
					if (currentChild.clickBkg)
					{
						currentChild.style.backgroundImage = 'url("'+currentChild.normalBkg+'")';
					}
					else
					{
						currentChild = currentChild.firstChild;
						if (currentChild)	// if there is a child, it is in image.
						{
							if (currentChild.normalSrc)
								currentChild.src = currentChild.normalSrc;
						}
					}
					currentChild = tdChild.nextSibling;
				}
			}
		}
	}
	catch(e) {};
}

//-----------------------------------------------------------------------------
function ezdv_displayDialog(html)
{
	//var w = window.open('about:blank');
	//w.document.body.innerText = html;
   try
   {
       var e = document.getElementById( kEZDialogViewDialogArea );
       if ( e )
       {  
         e.innerHTML = html;
         focusTimer = setTimeout("_ezdv_setFocusItem()",250);
   //      _ezdv_setFocusItem();
      }   
    } catch (exc) {}
}

//-----------------------------------------------------------------------------
function ezdv_accelarator( e )
    // Invoke the click event if space or enter key is pressed
{
   try
   {
       if( !e ) return;
    
       var evt = window.event;
       if( !evt ) return;
       if( 13 == evt.keyCode || 32 == evt.keyCode )
       {
          e.fireEvent("onclick");
       }
    } catch (exc) {}
}   

//-----------------------------------------------------------------------------
function _ezdv_disableAccelerators()
{
   try
   {
       var evt=window.event;
       if(!evt)return;
    
       var bCancel = false;
       var tag, btn;
    
       // Disable carriage return except in textareas (don't support select)
       // and links...which sends a mouse click event
       if( 13==evt.keyCode )
       {
           bCancel = true;
           if( evt.srcElement && evt.srcElement.tagName )
           {        
               tag = evt.srcElement.tagName.toLowerCase();
               if( "textarea" == tag ) bCancel = false;
               else if( "a" == tag )
               {
                   if( evt.srcElement.onclick ) evt.srcElement.fireEvent( "onclick" );
                   else bCancel = false;
               }    
               else if( "select" == tag ) bCancel = false;
               else if( "input" == tag && "button" == evt.srcElement.type ) bCancel = false;
           }
       }    
       // Disable backspace except in textareas and input text boxes
       else if( 8==evt.keyCode )
       {
           bCancel = true;
           if( evt.srcElement && evt.srcElement.tagName )
           {
               tag = evt.srcElement.tagName.toLowerCase();
               if( "input" == tag )
               {
                   var tp=evt.srcElement.type;
                   if( "text"==tp || "password"==tp ) bCancel = false; 
               }
               else if( "textarea" == tag ) bCancel = false;
           }    
       }
       // Space key on links and buttons behaves like the enter key
       else if( 32 == evt.keyCode )
       {
           if( evt.srcElement && evt.srcElement.tagName )
           {
               tag = evt.srcElement.tagName.toLowerCase();
               if( "a" == tag )
               {
                   if( evt.srcElement.onclick ) evt.srcElement.fireEvent( "onclick" );
                   else evt.keyCode = 13;
               }    
               else if( "input" == tag && "button" == evt.srcElement.type ) evt.keyCode = 13;
           }        
       }    
    
       if( bCancel )
       {
           evt.cancelBubble = true;
           evt.returnValue = false;
       }
    } catch (exc) {}
}

//-----------------------------------------------------------------------------
function _ezdv_disableDrag()
{
   try
   {
       var evt=window.event;
       if(!evt)return;

       evt.cancelBubble = true;
       evt.returnValue = false;
    } catch (exc) {}
}

//-----------------------------------------------------------------------------
function ezdv_getElementValue(id)
{
   try
   {
      var e = document.getElementById( id );
      if (e.type.match(/radio/) && !id.match(e.id)) 
      { 
         // The first RADIO in a group is returned from getElementById and the
         // radio buttons GROUPID (name) is passed, 
         // so hunt down the checked radio in that group
         var str = "";
         var radioButtons = document.getElementsByTagName("INPUT");
      	for ( var i=0; i<radioButtons.length; i++ )
      	{
      	   var radio = radioButtons[i];
      	   if (radio.type.match(/radio/))
      	   {
      	      // do bidirectional to ensure exact match
      	      if (id.match(radio.name) && radio.name.match(id))
      	      {
      	         if (radio.checked)
      	         {
      	            if (radio.ezdvValue)
      	               return radio.ezdvValue;
    	               return radio.id;
      	         }
      	      }
      	   }
      	}
         return str;
      }
      else if (e.type.match(/select-one/))
      {
         return e.options[e.selectedIndex].value;
      }
      else if (e.type.match(/text/) || e.type.match(/password/))
      {
         return e.value;
      }
      else if (e.type.match(/checkbox/) || e.type.match(/radio/))
      {
         if (e.checked)
         {
            if (e.ezdvValue)
               return e.ezdvValue;
            return e.id;
         }
         return "";
      }
   } catch (exe) {}
   return "";
}
//-----------------------------------------------------------------------------
function zedvStartTriggers()
{
   try
   {
      // Dynamic tags are wrapped by SPAN
      var spans = document.getElementsByTagName("SPAN");
      for ( var i=0; i<spans.length; i++ )
      {
         if (spans[i].ezdvInterval && spans[i].id) {
            setTimeout("zedvFireTrigger('"+spans[i].id+"',"+spans[i].ezdvInterval+");",spans[i].ezdvInterval);
         }
      }
   }
   catch (e) {};
}

//-----------------------------------------------------------------------------
function zedvFireAllTriggers()
{
   try
   {
      // Conditional/Dynamic tags are wrapped by SPAN
      var spans = document.getElementsByTagName("SPAN");
      for ( var i=0; i<spans.length; i++ )
      {
         if (spans[i].ezdvCall && spans[i].id) 
            setTimeout("zedvFireTrigger('"+spans[i].id+"');",250);
         if (spans[i].ezdvCondition && spans[i].id) 
            setTimeout("zedvFireTrigger('"+spans[i].id+"');",250);
      }
      // Conditional tags are wrapped by TD when in footer buttons
      var ids = document.getElementsByTagName("TD");
      for ( var i=0; i<ids.length; i++ )
      {
         if (ids[i].ezdvCall && ids[i].id) 
            setTimeout("zedvFireTrigger('"+ids[i].id+"');",250);
         if (ids[i].ezdvCondition && ids[i].id) 
            setTimeout("zedvFireTrigger('"+ids[i].id+"');",250);
      }
   }
   catch (e) {};
}

//-----------------------------------------------------------------------------
function zedvFireTrigger(id, interval)
{
   try
   {
      var e = document.getElementById( id );
      if (e.ezdvCall) 
      {
         e.innerHTML = eval(e.ezdvCall);
      }
      if (e.ezdvCondition) 
      {
         if (eval(e.ezdvCondition))
            e.style.display="";
         else
            e.style.display="none";
      }
      if (interval)
      {
         setTimeout("zedvFireTrigger('"+id+"',"+interval+");",interval);
      }
   }
   catch (e) { };
}

